<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Job extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'short_description', 'description', 'job_type', 'remote', 'location', 'country_id', 'section_id', 'published_at');

    public function section()
    {
        return $this->belongsTo('Section', 'section_id');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

}